﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Neurons;
namespace NNControl.NNTraining
{
    public partial class CreateNetworkForm : Form
    {
        Neurons.ConvolutionNetwork network;
        Neurons.Layer preLayer;
        List<Neurons.Layer> layers;
        Size inputPatternSize;
        List<Char> letters;
        bool isUnknownOutput;
        public Neurons.ConvolutionNetwork Network
        {
            get
            {
                return network;
            }
        }
        public CreateNetworkForm()
        {
            InitializeComponent();
            network = new ConvolutionNetwork();
            layers = null;
            preLayer = null;
            btConvolution.Enabled = false;
            btFullConnected.Enabled = false;
            btOutputLayer.Enabled = false;
            btOk.Enabled = false;
            inputPatternSize = Size.Empty;
            letters = null;
            isUnknownOutput = false;
        }
        private void AddLayerInformationToListView(Layer mLayer)
        {

            String label = mLayer.Label;
            ListViewGroup lvgroup = new ListViewGroup(label);
            lvNetwork.Groups.Add(lvgroup);
            String[] itemTexts = new String[6];
            int neurons = mLayer.NeuronCount;
            itemTexts[0] = neurons.ToString();
            itemTexts[1] = mLayer.FeatureMapSize.ToString();
            itemTexts[2] = mLayer.FeatureMapCount.ToString();
            itemTexts[3] = mLayer.WeightCount.ToString();
            itemTexts[4] = (mLayer.NeuronCount * mLayer.Neurons[0].ConnectionCount).ToString();
            switch (mLayer.LayerType)
            { 
                case LayerTypes.Input:
                    itemTexts[5] = "Input Layer";
                    break;
                case LayerTypes.ConvolutionalSubsampling:
                    itemTexts[5] = "Conv Layer";
                    break;
                case LayerTypes.FullyConnected:
                    itemTexts[5] = "Full Connected Layer";
                    break;
                case LayerTypes.Output:
                    itemTexts[5] = "Output Layer";
                    break;
            }
            ListViewItem item = new ListViewItem(itemTexts);
            lvNetwork.Items.Add(item);
            item.Group = lvgroup;

        }
        private void btInputLayer_Click(object sender, EventArgs e)
        {
            InputLayerForm mform = new InputLayerForm();
            if (mform.ShowDialog() == DialogResult.OK)
            {
                if (mform.Layer != null)
                {
                    if (layers == null)
                    {
                        layers = new List<Layer>();
                    }
                    layers.Add(mform.Layer);
                    inputPatternSize = mform.InputPatternSize;
                    preLayer = mform.Layer;
                    AddLayerInformationToListView(mform.Layer);
                    btConvolution.Enabled = true;
                    btFullConnected.Enabled = true;
                    btOutputLayer.Enabled = true;
                    btInputLayer.Enabled = false;
                }
            }
            
        }

        private void btConvolution_Click(object sender, EventArgs e)
        {
            ConvolutionForm mform = new ConvolutionForm(preLayer);
            if (mform.ShowDialog() == DialogResult.OK)
            {
                if (mform.Layer != null)
                {
                    if (layers != null&&preLayer!=null)
                    {
                        layers.Add(mform.Layer);
                        preLayer = mform.Layer;
                        AddLayerInformationToListView(mform.Layer);
                    }
                
                }
            }
        }

        private void btFullConnected_Click(object sender, EventArgs e)
        {
            FullConnectedForm mform = new FullConnectedForm(preLayer);
            if (mform.ShowDialog() == DialogResult.OK)
            {
                if (mform.Layer != null)
                {
                    if (layers != null && preLayer != null)
                    {
                        layers.Add(mform.Layer);
                        preLayer = mform.Layer;
                        AddLayerInformationToListView(mform.Layer);
                    }

                }
            }
        }

        private void btOutputLayer_Click(object sender, EventArgs e)
        {
            OutputLayerForm mform = new OutputLayerForm(preLayer);
            if (mform.ShowDialog() == DialogResult.OK)
            {
                if (mform.Layer != null)
                {
                    if (layers != null && preLayer != null)
                    {
                        letters = mform.OutputLetters;
                        isUnknownOutput = mform.IsUnknownOutput;
                        layers.Add(mform.Layer);
                        preLayer = mform.Layer;
                        AddLayerInformationToListView(mform.Layer);
                        btConvolution.Enabled = false;
                        btFullConnected.Enabled = false;
                        btOutputLayer.Enabled = false;
                        btInputLayer.Enabled = false;
                        btOk.Enabled = true;
                    }

                }
            }
        }

        private void btOk_Click(object sender, EventArgs e)
        {
            if (letters.Count > 0)
            {
                network.Layers = layers.ToArray();
                network.LayerCount = layers.Count;
                network.InputDesignedPatternSize = inputPatternSize;
                network.TagetOutputs = letters;
                network.IsUnknownOutput = isUnknownOutput;
                this.DialogResult = DialogResult.OK;
                this.Close();
            }
        }
    }
}
